// Map inventory dBox
   
dbox "map inventory"  title: "Map Inventory"

// This version by Stewart Berry - Caliper Corporation - 09/02

    // Creates an inventory for each map open in the current workspace

    // Details for each geographic file are provided
    // Note that the directory for the file can be scrolled and therefore no directory 
    // name is too long to be viewed   

    // You can also use this resource file to learn about how to manipulate 
    // and work with GISDK.

    // To run this dbox using the Maptitude GISDK toolbox:
    // 1. Choose Tools-Add-Ins and open the GIS Developer's Kit toolbox.
    // 2. Compile this file in test mode using the first button (Compile).
    // 3. Run this dbox by clicking the second button (Test), typing the dbox 
    //    name "map inventory", clicking the Dialog Box radio button, and
    //    clicking OK.
    
    //Initialise
    init do     
        available_map = GetWindows("map")       
        chosen_map = 1  
        chosen_layer = 1
        // Check for maps       
        if available_map = null then do
            ShowMessage("Map Inventory only works with open map files.")            
            Return()
            
        end 
            
        // Get all layer names      
        for k = 1 to ArrayLength(available_map[1]) do
          layers = GetMapLayers(available_map[1][k], "all")
          list = list + {layers[1]}       
        end 
            
        RunMacro("Get Display Data")            
    enditem
    
    //Create dbox Items and lists 
    Frame "map data" 1.5, .5, 56, 10.5 Prompt: "Map Data"
    Text "Map..." 3, 1.5 
    Scroll List "available maps" 3, 2.7, 25, 8 List: available_map[1] Variable: chosen_map
        do          
          chosen_layer = 1        
          RunMacro("Get Display Data")            
        enditem
    Text "Contains Layers..." 31, 1.5 
    
    Scroll List "active layers" 31, 2.7, 25, 8 List: list[chosen_map] Variable: chosen_layer
        do         
         RunMacro("Get Display Data")            
        enditem    
        
        Button "Close" 60, 1, 10 
            do          
             Return()        
            endItem
           
    //Create dbox text items       
    Frame "Layer data" 1.5, 11.5, 56, 9.3 Prompt: "Layer Data"
    
    Text"Layer..."    13, 12.5, 19    Prompt: "Layer:"      Variable: list[chosen_map][chosen_layer] Framed
    Text"Type..."     42, same, 14    Prompt: "Type:"       Variable: lay_type Framed 
    Edit Text"directory..." 13, 14, 43                      Variable: file_path Disabled//Framed
    Text"Directory:" 4.5, 14, 7.5
    Text"filename..." 13, 15.5, 19    Prompt: "Filename:"   Variable: file_name1 Framed
    Text"filesize..." 42, same, 14    Prompt: "Filesize:"   Variable: i2s(filestat[6]) + " bytes" Framed
    Text"Created..."  13, 17, 19      Prompt: "Created:"    Variable: filestat[7] Framed
    Text"Records..."  42, same, 14    Prompt: "Records:"    Variable: recs Framed
    Text"maps..."     13, 18.5, 43, 2 Prompt: "Appears in:" Variable: maps Framed
    
    // Build entries for layer data    
    Macro "Get Display Data" do
        layer = GetLayerInfo(list[chosen_map][chosen_layer])    
        tmp = SplitPath(layer[10])
        file_path  = tmp[1] + tmp[2]    
        file_name1 = tmp[3] + tmp[4]
      
      // check for layer in other maps        
        maps = null
        for i = 1 to available_map[1].length do
            if ArrayPosition(list[i], {list[chosen_map][chosen_layer]}, ) > 0 then do
               maps = maps + available_map[1][i] + ", "                
            end         
        end
        maps = Left(maps, Len(maps) - 2)
        lay_type = GetLayerType(list[chosen_map][chosen_layer])
        filestat = GetFileInfo(layer[10])
        recs     = GetRecordCount(list[chosen_map][chosen_layer], )    
        
        enditem
        
  
endDBox
